#### Model 2: No interaction terms                            ####
# ################################################################# #

### initialise apollo and core settings
apollo_initialise()
apollo_control= list (
  modelName = "modelclogitbase",
  modelDescr ="Conditional Logit in preference space without Interaction Terms",
  indivID = "ID",
  mixing = FALSE, # Mixed Logit
  HB=FALSE,
  nCores=1,
  outputDirectory = "modeloutput/"
)



# ################################################################# #
#### DEFINE MODEL PARAMETERS                                     ##
# ################################################################# #

### Starting values
apollo_beta=c(bascgemeinschaft = 0.61,
              bascklein = 0.43,
              bgroesse = 0.0,
              bentfernung = -0.17,
              bgemeinschaft = 0.06,
              bkultur = 0.06,
              bumweltbildung = 0.13,
              bzugang = 0.05,
              bgestaltung = 0.31,
              bbeitrag = -0.12

)

### keine Parameter fix halten
apollo_fixed = c()








# ################################################################# #
#### DEFINE MODEL AND LIKELIHOOD FUNCTION                        ##
# ################################################################# #



### validieren
apollo_inputs = apollo_validateInputs()
apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate"){
  
  ### Function initialisation: do not change the following three commands
  ### Attach inputs and detach after function exit
  apollo_attach(apollo_beta, apollo_inputs)
  on.exit(apollo_detach(apollo_beta, apollo_inputs))
  
  ### Create list of probabilities P
  P = list()
  
  ### List of utilities (later integrated in mnl_settings below)
  V = list()
  
  V[['alt1']] = 
    bascgemeinschaft  +
       
       bgroesse * GROESSE.1  +
       
       bentfernung * ENTFERNUNG.1  +
       
       bgemeinschaft * GEMEINSCHAFTSAKTIVITAETEN.1 +
       
       bkultur * KULTURVERANSTALTUNGEN.1 +
       
       bumweltbildung * UMWELTBILDUNG.1 +
       
       bzugang * ZUGANG.1 +
       
       bgestaltung * GESTALTUNG.1  -
       
       bbeitrag*BEITRAG.1
  
  V[['alt2']] = 
    bascklein +
       
       bgroesse * GROESSE.2 +
       
       bentfernung * ENTFERNUNG.2 +
       
       bgemeinschaft * GEMEINSCHAFTSAKTIVITAETEN.2 +
       
       bkultur * KULTURVERANSTALTUNGEN.2 +
       
       bumweltbildung * UMWELTBILDUNG.2 +
       
       bzugang * ZUGANG.2 +
       
       bgestaltung * GESTALTUNG.2 -
       
       bbeitrag* BEITRAG.2
  
  V[['alt3']] = 0
  
  ### Define settings for MNL model component
  mnl_settings = list(
    alternatives  = c(alt1=1, alt2=2, alt3=3),
    avail         = 1, # all alternatives are available in every choice
    choiceVar     = choice,
    V             = V#,  # tell function to use list vector defined above

  )
  
  ### Compute probabilities using MNL model
  P[['model']] = apollo_mnl(mnl_settings, functionality)
  
  ### Take product across observation for same individual
  P = apollo_panelProd(P, apollo_inputs, functionality)
  

  
  ### Prepare and return outputs of function
  P = apollo_prepareProb(P, apollo_inputs, functionality)
  return(P)
}



# ################################################################# #
#### MODEL ESTIMATION                                            ##
# ################################################################# #

modelclogitbase = apollo_estimate(apollo_beta, apollo_fixed,
                                              apollo_probabilities, apollo_inputs, estimate_settings=list(maxIterations=400, estimationRoutine="bfgs",
                                                                                                          hessianRoutine="analytic"))



# ################################################################# #
#### MODEL OUTPUTS                                               ##
# ################################################################# #



apollo_saveOutput(modelclogitbase)


detach(package:apollo,  unload=TRUE)



# ################################################################# #




