


apollo_beta=c(asc = 0,
              preis =0,
#              gesamtzeit = 0
              ladezeit =0,
              wartezeit=0
              )


### keine Parameter fix halten
apollo_fixed = c("asc")

### validieren
apollo_inputs = apollo_validateInputs()


apollo_probabilities=function(apollo_beta, apollo_inputs, functionality="estimate"){
  
  ### Function initialisation: do not change the following three commands
  ### Attach inputs and detach after function exit
  apollo_attach(apollo_beta, apollo_inputs)
  on.exit(apollo_detach(apollo_beta, apollo_inputs))
  
  ### Create list of probabilities P
  P = list()
  
  ### List of utilities (later integrated in mnl_settings below)
  V = list()
  V[['alt1']] =   preis*(asc -a1_x1  + ladezeit*a1_LADEZEIT + wartezeit*a1_WARTEZEIT)
  V[['alt2']] =   preis*(asc -a2_x1  + ladezeit*a2_LADEZEIT + wartezeit*a2_WARTEZEIT)
  
  # V[['alt1']] =   (asc +preis*a1_x1  + gesamtzeit*a1_GESAMTZEIT)
  # V[['alt2']] =   (asc +preis*a2_x1  + gesamtzeit*a2_GESAMTZEIT)
  

  ### Define settings for MNL model component
  mnl_settings = list(
    alternatives  = c(alt1=1, alt2=2) ,
    avail         = 1, # all alternatives are available in every choice
    choiceVar     = pref1,
    V             = V  # tell function to use list vector defined above
    
  )
  
  ### Compute probabilities using MNL model
  P[['model']] = apollo_mnl(mnl_settings, functionality)
  
  ### Take product across observation for same individual
  P = apollo_panelProd(P, apollo_inputs, functionality)
  
  ### Average across inter-individual draws - nur bei Mixed Logit!
  ### P = apollo_avgInterDraws(P, apollo_inputs, functionality)
  
  ### Prepare and return outputs of function
  P = apollo_prepareProb(P, apollo_inputs, functionality)
  return(P)
}

