## Estimate clogit model


clpath <- "modeloutput/WTPSpace/clogit_wtpspace/"

##### All respondents ####



apollo_initialise()


modelOutput_settings = list(printPVal=T)

### Set core controls
apollo_control = list(
  modelName  ="clog_pretest",
  modelDescr ="Simple MNL model with all respondents",
  indivID    ="RID", 
  nCores=1,
  outputDirectory = clpath
)


source("scripts/clogitbody.R")


clog_allsamples = apollo_estimate(apollo_beta, apollo_fixed,
                        apollo_probabilities, apollo_inputs, 
                        estimate_settings=list(maxIterations=4000, estimationRoutine="bhhh",
                                               hessianRoutine="analytic"))





apollo_saveOutput(clog_allsamples,  saveOutput_settings = list(saveCov=FALSE, saveCorr=FALSE))  


