# Functions to compute shares 

sum_cover <- function(x){
  list(x %>%
         group_by(value) %>%
         summarize(total_area = sum(coverage_area, na.rm=T)) %>%
         mutate(proportion = total_area/sum(total_area[1:2])))
  
}

process_data <- function(data, name_prefix, cover_data) {
  result <- exact_extract(data, buffer_pts, fun=sum_cover, coverage_area=T, summarize_df=T)
  col_name <- paste(name_prefix)
  result <- as.data.frame(sapply(result, function(x) ifelse(length(x$proportion) >= 2, x$proportion[2], 0)))
  colnames(result) <- col_name
  result <- result %>% mutate(ID = 1:resps) %>% dplyr::select(ID, everything())
  return(result)
}


##### Load in GIS data ####

## Draw random points without incorporating actual pop density (old)
# random_points <- st_sample(germany_geo_county, size = resps)
# plot(germany_geo) + plot(random_points, add=T)

#### Draw respondents ####
# Load population density data for Germany

density_raster <- rast("Projects/ValuGaps/data/gis/BBSR_Landnutzung_Bevoelkerung/ewz250_2011_v1_multi.tif")
  


#### Draw cells from raster considering population density as probability weights ####

random_points <- spatSample(density_raster, resps, method="weights", replace= TRUE, as.points=TRUE) 
# set replace to TRUE to sample with replacement

random_points_ls <- base::split(sample(random_points), 1:length(buffer_dist_ls))

# Draw Buffer around random points 

#### Split samples ####
buffer_pts_ls <- list()

buffer_pts_ls <- lapply(seq_along(random_points_ls), function(i) {
  buffered <- buffer(random_points_ls[[i]], buffer_dist_ls[[i]])
  buffered_sf <- st_as_sf(buffered, crs = crs(hnv))
  buffered_sf
})

buffer_pts <- do.call(rbind, buffer_pts_ls)



### Equalize CRS's to avoid warning message; can be done here without problems as CRS is formally the same anyway

crs(hnv) <- crs(corine_hnv) <- crs(protected_areas) <- crs(corine_pa)

# Compute shares within Buffer with exact_extract and customized functions


hnv_shares <- process_data(hnv, "HNV", buffer_pts_ls)

hnv_possible <- process_data(corine_hnv, "HNV_possible", buffer_pts_ls)

protected_shares <- process_data(protected_areas, "protected", buffer_pts_ls)

protected_possible <- process_data(corine_pa, "Protected_possible", buffer_pts_ls)

# Merge protected area shares and HNV shares
land_cover_shares <- left_join(protected_shares, hnv_shares, by="ID")

possible_shares <- left_join(protected_possible, hnv_possible, by="ID") 

final_set <- left_join(land_cover_shares, possible_shares, by="ID") %>% 
  mutate(HNV_on_corine = HNV/HNV_possible, Protected_on_corine = protected/Protected_possible,
         buffer_dist_index = ceiling(row_number() / (resps / length(buffer_dist_ls))),
         buffer_dist = map_dbl(buffer_dist_index, ~ buffer_dist_ls[[.]]),
         SQ_HNV = (buffer_dist^2*HNV*pi)/10000,
         SQ_Prot = (buffer_dist^2*protected*pi)/10000) 

###################################################################################
#### Overview of GIS shares ####

# library(ggpubr)
# pa_pl <- ggplot(data=final_set) +
#   geom_density(aes(x=Protected_on_corine), fill="lightblue") +
#   xlab("Protected areas (% of possible)") +
#   xlim(0:1)
# 
# hnv_pl <- ggplot(data=final_set) +
#   geom_density(aes(x=HNV_on_corine), fill="lightblue") +
#   xlab("HNV (% of possible)") + xlim(0:1)
# 
# pa_pos <- ggplot(data=final_set) +
#   geom_density(aes(x=Protected_possible), fill="yellow") +
#   xlab("Protected possible share") + xlim(0:1)
# 
# hnv_pos <- ggplot(data=final_set) +
#   geom_density(aes(x=HNV_possible), fill="yellow") +
#   xlab("HNV possible share") + xlim(0:1)
# 
# pa_sq <- ggplot(data=final_set) +
#   geom_density(aes(x=SQ_Prot), fill="lightgreen") +
#   xlab("Protected areas SQ (ha)") + xlim(0,40000)
# 
# hnv_sq <- ggplot(data=final_set) +
#   geom_density(aes(x=SQ_HNV), fill="lightgreen") +
#   xlab("HNV SQ (ha)") + xlim(0,40000)
# 
# ggarrange(pa_pl, hnv_pl, pa_pos, hnv_pos, pa_sq, hnv_sq, nrow = 3, ncol=2)
# 
# ggsave("Figures/finalset_gis.png", dpi="print", width = 8, height = 6)
###################################################################################
