#include "console.h"
#include "qcoreapplication.h"

#include <QDebug>
#include <QCoreApplication>
#include <iostream>
#include <math.h>

void Console::listenKeys()
{
	// listen to keyevents in endless loop
	/* This is an expensive or blocking operation, why we use threaded approach to not block main event loop! */
	std::string line;
	forever
	{
		std::getline(std::cin, line);
		emit keyPressed(line[0]);
		if( line[0] == 'q' )
			break;
	}
}

void Console::updateCam(const QStringList& camInfo )
{
	qDebug() << camInfo;
}

Controller::Controller()
{
	Console *console = new Console;
	console->moveToThread(&thread);
	connect(&thread, &QThread::finished, console, &QObject::deleteLater);
	connect(this, &Controller::operate, console, &Console::listenKeys);
	connect(console, &Console::keyPressed, this, &Controller::keyPress);
	thread.start();
}

Controller::~Controller()
{
	thread.quit();
	thread.wait(); //wait for thread to finish
	// qDebug() << __FUNCTION__ << "():" << __LINE__ << ": ";
}

void Controller::keyPress(const QChar& key)
{
	qDebug() << __FUNCTION__ << "u pressed " << key;
	switch (key.unicode())
	{
		case 'l':
			emit listCams();
			break;
		case 'q':
			qApp->quit();
			break;
	}
}
