#pragma once

#include <QObject>
#include <QThread>

// derived from qthread example
// https://doc.qt.io/qt-6/qthread.html

class Console : public QObject
{
	Q_OBJECT

	public slots:
		void updateCam(const QStringList &);
		void listenKeys();

	signals:
		void keyPressed(const QChar &key);

};

class Controller : public QObject
{
	Q_OBJECT
	QThread thread;

	public:
		Controller();
		~Controller();

	public slots:
		void keyPress(const QChar &);

	signals:
		void operate();
		void listCams();
		void printVersion();
		// ... more signals here

};
