#include "core.h"
#include "../utils.h"

#include <iostream>
#include <vector>

#include <VmbCPP/VmbCPP.h>

// #include "qglobal.h"
#include <QDebug>

using namespace VmbCPP;

Core::Core() :
	apiStarted( false ),
	sys( VmbSystem::GetInstance() ), // Create and get Vimba singleton
	cameras( CameraPtrVector() ), // Holds camera handles
	camIdx(0)
{
	if ( VmbErrorSuccess == sys.Startup() )
	{
		apiStarted = true;
		qDebug() << "init API :)";
	}
	else
	{
		qDebug() << "Couldn't initialize API";
	}

	initCams();

}


void Core::initCams()
{
	if ( VmbErrorSuccess == sys.GetCameras( cameras ) )
	{
		qDebug() << "found " << cameras.size() << " cameras";
	}
	else
	{
		qDebug() << "Couldn't get cameras";
	}
}

Core::~Core()
{
	// close each camera in cameras
	for ( auto iter = cameras.begin (); cameras.end () != iter; ++ iter )
		(*iter)->Close();

	qDebug() << __FUNCTION__ << "():" << __LINE__;
	sys.Shutdown(); //unload TL's
}


CameraPtr Core::cam()
{
	return cameras.at(camIdx);
}

void Core::setCam(ulong idx)
{
	if( idx >= cameras.size() )
		idx = cameras.size() - 1;

	camIdx = idx;
}

void Core::listCams()
{

	qDebug() << __FUNCTION__ << "():" << __LINE__;
	if( !apiStarted )
		return;

	// id,name,model,serial,interfaceID
	std::for_each( cameras.begin(), cameras.end(), [this](const CameraPtr & camera)
	{
		std::string str;
		QStringList camInfo;

		VmbErrorType err = camera->GetID( str );
		if( VmbErrorSuccess != err )
			str =  errorCodeToMessage(err).toStdString();
		camInfo << QString::fromStdString(str);

		err = camera->GetName( str );
		if( VmbErrorSuccess != err )
			str =  errorCodeToMessage(err).toStdString();
		camInfo << QString::fromStdString(str);

		err = camera->GetModel( str );
		if( VmbErrorSuccess != err )
			str =  errorCodeToMessage(err).toStdString();
		camInfo << QString::fromStdString(str);

		err = camera->GetSerialNumber( str );
		if( VmbErrorSuccess != err )
			str =  errorCodeToMessage(err).toStdString();
		camInfo << QString::fromStdString(str);

		err = camera->GetInterfaceID( str );
		if( VmbErrorSuccess != err )
			str =  errorCodeToMessage(err).toStdString();
		camInfo << QString::fromStdString(str);

		camInfo << "closed"; //initially cams are closed, right?

		qDebug() << camInfo;
		emit camsDetected(camInfo);
	} );

}



