#pragma once

#include "qglobal.h"
#include <QObject>
#include <VmbCPP/Interface.h>

namespace VmbCPP {
	class VmbSystem;
}
using VmbCPP::CameraPtr;

class Core : public QObject
{
	Q_OBJECT

	public:
		Core();
		~Core();

	public slots:
		void listCams();

	signals:
		void camsDetected(const QStringList &);

	private:
		void initCams();
		static void getCamInfo( const CameraPtr & );
		CameraPtr cam();
		void setCam(ulong idx);

		bool apiStarted;
		VmbCPP::VmbSystem& sys;
		VmbCPP::CameraPtrVector cameras;
		ulong camIdx;
};
