#include "../utils.h"
#include "console.h"
#include "core.h"

#include <iostream>

#include <QCoreApplication>
#include <QCommandLineParser>
#include <QDir>
#include <QTimer>

using namespace std; //string/cin/cerr/cout/endl

bool maybeCreateDir(QDir out_dir)
{
	if( !out_dir.exists() )
	{
		qDebug() << "out_dir (" << out_dir.absolutePath() << ") doesn't exist. Should I Create it? ['y'-yes, '?'-no]\n";
		char c='y';
		cin >> c;
		if( c == 'y' )
		{
			cout << "u pressed yes" << endl;
			if( out_dir.mkpath(out_dir.absolutePath())) {
				cout << "created out_dir" << endl;
			}
			else
			 {
				cerr << "failed to create out_dir '" << out_dir.absolutePath().toStdString()  << "'" << endl;
				return false;
			}
		}
		else
		{
			cout << "u pressed no" << endl;
			return false;
		}
	}
	qDebug() << "out_dir: " << out_dir.dirName() << "\n";
	return true;
}

 int main(int argc, char *argv[])
{

	QCoreApplication a(argc, argv);
	QCoreApplication::setApplicationVersion(getVersionString());
	QCoreApplication::setApplicationName("recorder");

	Controller controller;
	QTimer::singleShot(0, &controller, SIGNAL(operate()));

	Core core;
	QObject::connect(&controller, &Controller::listCams, &core, &Core::listCams);

	QObject::connect(&core, &Core::camsDetected, &console, &Console::updateCam);


	// for testing:
	QTimer::singleShot(0, &core, SLOT(listCams()));



	return a.exec();
}



// // parse arguments
	// QCommandLineParser parser;
	// parser.setApplicationDescription("a commandline app that is meant to be standalone and communicates with the camera");
	// parser.addHelpOption();
	// parser.addVersionOption();
	// parser.addOptions({
	// 	{{"o", "out-dir"}, "store frames to <out-dir>", "out_dir"},
	// 	{{"l", "list-cams"}, "list available cams"},
	// 	{{"e", "export-cam-config"}, "export camera config" "settings.xml"},
	// 	{{"i", "import-cam-config"}, "import camera config" "settings.xml"},
	// 	{{"c", "calibrate"}, "calibrate cam"},
	// 	{{"r", "start record"}, "record"},
	// 	{{"s", "stop record"}, "stop recording"},
	// 	// {{"f", "force"}, "Overwrite existing files."},
	// 	// {{"n", "dry-run"}, "Do nothing. For testing purposes."},
	// 	// {{"p", "progress"}, "Show progress during copy."},
	// 	// {{"v", "verbose"}, "verbose"},
	// });

	// parser.process(a);

	// const QStringList args = parser.positionalArguments();
	// // source is args.at(0), destination is args.at(1)
	// qDebug() << "args: " << args.join(", ") << "\n";

	// if( parser.isSet("o") )
	// {
	// 	maybeCreateDir(parser.value("o"));
	// }
