#include "mainwindow.h"

#include <QApplication>
#include <QFile>
// #include <QDir>


void loadStyleSheets(const QString& name, MainWindow& mw)
{
    QFile file(name);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        mw.log( "didn't find '" + name + "'" );
    }
    else
    {
        mw.log("init styles");
        qApp->setStyleSheet( file.readAll() );
    }
}

int main(int argc, char *argv[])
{

    QApplication a(argc, argv);
    MainWindow w;
    loadStyleSheets(QCoreApplication::applicationDirPath()+"/style.qss", w);

    w.show();
    return a.exec();
}

