#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <VmbCPP/VmbCPP.h> //cameraptrvector (cant fwddcl typedef), vimbasys (could fwd decl)

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE


class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = nullptr);
	~MainWindow();

public slots:
	void log(QString,VmbError_t err = VmbErrorJustInfo);

private slots:
	void updateCams();
	void openCloseCam();
	void selectCam(int,int);

protected:
	void keyPressEvent(QKeyEvent *);

private:
	void getCamInfo( const VmbCPP::CameraPtr &camera );
	void addRow( QStringList& );

	Ui::MainWindow *ui;
	VmbCPP::VmbSystem &sys;

	VmbCPP::CameraPtr curCam;
	VmbCPP::CameraPtrVector cameras;
	QStringList camInfoNames;
};
#endif // MAINWINDOW_H
