#include "opencv2/core/version.hpp"

#include <random>

// #include "mainwindow.h"
#include "VmbCPP/VmbCPP.h"
#include <QString>
#include <QDebug>


const int APP_VERSION_MAJOR = 0;
const int APP_VERSION_MINOR = 0;
const int APP_VERSION_PATCH = 5;

using namespace VmbCPP;

const QString getVersionString()
{
    VmbVersionInfo_t version;
    VmbSystem::GetInstance().QueryVersion(version);

    QString s = "\n### Versions\n";
    s += QStringLiteral("# Recorder: %1.%2.%3\n").arg(APP_VERSION_MAJOR).arg(APP_VERSION_MINOR).arg(APP_VERSION_PATCH);
    s += QStringLiteral("#    Vimba: %1.%2.%3\n").arg(version.major).arg(version.minor).arg(version.patch);
    s += QStringLiteral("#       Qt: %1.%2.%3\n").arg(QT_VERSION_MAJOR).arg(QT_VERSION_MINOR).arg(QT_VERSION_PATCH);
    s += QStringLiteral("#   openCV: %1.%2.%3\n").arg(CV_VERSION_MAJOR).arg(CV_VERSION_MINOR).arg(CV_VERSION_REVISION);

    return s;
}


const QString errorCodeToMessage( VmbError_t err )
{
    QString msg = "error: ";
    switch( err )
    {
        default:                        msg += "Unknown"; break;
        case VmbErrorJustInfo:          msg = ""; break; //custom
        case VmbErrorSuccess:           msg = "Success"; break;
        case VmbErrorInternalFault:     msg += "Unexpected fault in VmbApi or driver."; break;
        case VmbErrorApiNotStarted:     msg += "API not started."; break;
        case VmbErrorNotFound:          msg += "Not found."; break;
        case VmbErrorBadHandle:         msg += "Invalid handle "; break;
        case VmbErrorDeviceNotOpen:     msg += "Device not open."; break;
        case VmbErrorInvalidAccess:     msg += "Invalid access."; break;
        case VmbErrorBadParameter:      msg += "Bad parameter."; break;
        case VmbErrorStructSize:        msg += "Wrong DLL version."; break;
        case VmbErrorMoreData:          msg += "More data returned than memory provided."; break;
        case VmbErrorWrongType:         msg += "Wrong type."; break;
        case VmbErrorInvalidValue:      msg += "Invalid value."; break;
        case VmbErrorTimeout:           msg += "Timeout."; break;
        case VmbErrorOther:             msg += "TL error."; break;
        case VmbErrorResources:         msg += "Resource not available."; break;
        case VmbErrorInvalidCall:       msg += "Invalid call."; break;
        case VmbErrorNoTL:              msg += "TL not loaded."; break;
        case VmbErrorNotImplemented:    msg += "Not implemented."; break;
        case VmbErrorNotSupported:      msg += "Not supported."; break;
    }
    return msg;
}

QString randomString()
{
    QStringList list{"a", "b", "c", "d", "e", "f", "g"};
    //, "h", "i", "j", "k", "l", "m"};
    std::random_device rd;
    std::mt19937 g(rd());
    std::shuffle(list.begin(), list.end(), g);
    QString randomString = list.join("");
    qDebug() << "Random string:" << randomString;
    return randomString;
}
